<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>bill</title>
    <!-- font google  -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;700;900&display=swap"
        rel="stylesheet">
    <!-- bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <!-- main css -->
    <link rel="stylesheet" href="/assets2/css/style.css">
    <!--bill css-->
    <link rel="stylesheet" href="/assets2/css/bill/bill.css">
</head>

<body dir="rtl">
    <div class="container-fluid">
        <div class="container">
            <div class="title-bill text-center">
                <h5 style="font-weight:600">فاتوره ضاربيه</h5>
                <h5 style="font-weight:600">Tax Invoice</h5>
            </div>
            <div class="row justify-content-between">
                <div class="col-md-3">
                    <div class="qr mt-5">
                      <?php echo $slug; ?>

                    </div>
                </div>
                <div class="col-md-8">
                    <div class="invoice-content mt-5">
                        <div class="invoice-number d-flex justify-content-between">
                            <div> رقم الفاتوره :</div>
                            <div><?php echo e($data->id); ?></div>
                            <div class="text-end"><?php echo e($data->id); ?></div>
                            <div class="text-end">invoice number : </div>
                        </div>
                        <div class="invoice-data-iss mt-5 d-flex justify-content-between">
                            <div> ترزيخ اصدار الفاتوره :</div>
                            <div><?php echo e($data->created_at->format('d/m/Y')); ?></div>
                            <div dir="ltr"><?php echo e($data->created_at->format('d/m/Y')); ?></div>
                            <div dir="ltr">invoice sll data : </div>
                        </div>
                        <div class="invoice-data-supplierly d-flex justify-content-between">
                            <div>تاريخ التوريد : </div>
                            <div><?php echo e($data->date_of_supplierly); ?></div>
                            <div dir="ltr"><?php echo e($data->date_of_supplierly); ?></div>
                            <div dir="ltr">Data Of supplierly : </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-5">
                <div class="col-md-6 mt-5">
                    <table class="table table-bordered">
                        <thead class="main-bill-thead">
                            <tr>
                                <th scope="col-6">العميل</th>
                                <th scope="col"></th>
                                <th scope="col"></th>
                                <th scope="col-6" class="text-end">buyer</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>الاسم : <?php echo e($data->supplier->supplier_name  ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->supplier->supplier_name ?? 'null'); ?> : name</td>
                            </tr>
                            <tr>
                                <td>رقم المبني :<?php echo e($data->supplier->building_num ?? 'null'); ?> </td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->supplier->building_num  ?? 'null'); ?> : Building Number </td>
                            </tr>
                            <tr>
                                <td>اسم الشارع : <?php echo e($data->supplier->street_name ?? 'null'); ?> </td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->supplier->street_name  ?? 'null'); ?> : Street name </td>
                            </tr>
                            <tr>
                                <td>الحي : <?php echo e($data->supplier->location ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->supplier->location ?? 'null'); ?> : Neighborhood </td>
                            </tr>
                            <tr>
                                <td>المدينة : <?php echo e($data->supplier->city ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> <?php echo e($data->supplier->city ?? 'null'); ?> : City </td>
                            </tr>
                            <tr>
                                <td>البلد : <?php echo e($data->supplier->country ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> <?php echo e($data->supplier->country ?? 'null'); ?> : Country</td>
                            </tr>
                            <tr>
                                <td>الرمز البريدي : <?php echo e($data->supplier->postal_code ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->supplier->postal_code ?? 'null'); ?> : Postal code </td>
                            </tr>
                            <tr>
                                <td> رقم الهاتف : <?php echo e($data->supplier->phone ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> <?php echo e($data->supplier->phone ?? 'null'); ?>: Phone No </td>
                            </tr>
                            <tr>
                                <td>الرقم الضريبي : <?php echo e($data->supplier->tax_number ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> <?php echo e($data->supplier->tax_number ?? 'null'); ?> : VAT Number </td>
                            </tr>
                            <tr>
                                <td>رقم معرف أخر :</td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> : Other ID  </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-6 mt-5">
                    <table class="table table-bordered" >
                        <thead class="main-bill-thead">
                            <tr >
                                <th scope="col">المورد</th>
                                <th scope="col"></th>
                                <th scope="col"></th>

                                <th scope="col" class="text-end">saller</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>الاسم : <?php echo e($data->branch->name  ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->branch->name ?? 'null'); ?> : name</td>
                            </tr>
                            <tr>
                                <td>رقم المبني :<?php echo e($data->branch->building ?? 'null'); ?> </td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->branch->building  ?? 'null'); ?> : Building Number </td>
                            </tr>
                            <tr>
                                <td>اسم الشارع : <?php echo e($data->branch->street ?? 'null'); ?> </td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->branch->street ?? 'null'); ?> : Street name </td>
                            </tr>
                            <tr>
                                <td>الحي : <?php echo e($data->branch->area ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->branch->area ?? 'null'); ?> : Neighborhood </td>
                            </tr>
                            <tr>
                                <td>المدينة : <?php echo e($data->branch->city ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> <?php echo e($data->branch->city  ?? 'null'); ?> : City </td>
                            </tr>
                            <tr>
                                <td>البلد : <?php echo e($data->branch->country ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> <?php echo e($data->branch->country  ?? 'null'); ?> : Country</td>
                            </tr>
                            <tr>
                                <td>الرمز البريدي : <?php echo e($data->branch->postal_code ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"><?php echo e($data->branch->postal_code  ?? 'null'); ?> : Postal code </td>
                            </tr>
                            <tr>
                                <td> رقم الهاتف : <?php echo e($data->branch->phone ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> <?php echo e($data->branch->phone ?? 'null'); ?>: Phone No </td>
                            </tr>
                            <tr>
                                <td>الرقم الضريبي : <?php echo e($data->branch->tax_number ?? 'null'); ?></td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> <?php echo e($data->branch->tax_number?? 'null'); ?> : VAT Number </td>
                            </tr>
                            <tr>
                                <td>رقم معرف أخر :</td>
                                <td></td>
                                <td></td>
                                <td class="text-end"> : Other ID  </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row mt-5">
                <div class="col-12">
                    <div class="title-table">
                        <div class="row">
                            <div class="col-6">
                                <h5>توصيف السلعه او الخدمه :</h5>

                            </div>
                            <div class="col-6 text-end">
                                <h5> : Line Items </h5>
                            </div>
                        </div>

                    </div>

                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <table class="table table-bordered">

                        <thead>
                            <tr style="background-color: #F0E3CA; ">
                                <th>
                                    Item Subtotal <br />
                                    (Including VAT) <br/>
                                    المجموع شامل ضريبة <br>
                                    القيمة المضافة

                                </th>
                                <th>
                                    Tax Amount <br>
                                    مبلغ الضريبة
                                </th>
                                <th>
                                    Tax Rate <br>
                                    نسبة الضريبة
                                </th>
                                <th>
                                    Discount <br />
                                    الخصم
                                </th>
                                <th>
                                    Taxable Amount <br>
                                     المبلغ الخاضع  للضريبة

                                </th>
                                <th>
                                    Quantity <br />
                                    الكمية
                                </th>
                                <th>
                                    Unit Price<br />
                                    سعر الوحدة
                                </th>
                                <th>
                                    Nature of goods<br />
                                    or services <br>
                                    تفاصيل السلعة <br>
                                    أو الخدمة
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data->product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                               <td><?php echo e($v->selling * $v->pivot->quantity + $data->branch->tax  * $v->selling * $v->pivot->quantity /100); ?> SAR</td>
                               <td><?php echo e($data->branch->tax * $v->selling * $v->pivot->quantity /100); ?> SAR</td>
                                <td><?php echo e($data->branch->tax); ?>%</td>
                                <td><?php echo e($data->discount_per); ?></td>
                                <td><?php echo e($v->pivot->quantity * $v->selling); ?></td>
                                <td><?php echo e($v->pivot->quantity); ?></td>
                                <td><?php echo e($v->selling); ?> SAR</td>
                                <td><?php echo e($v->name); ?></td>
                            </tr>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                        </tbody>
                    </table>
                </div>

            </div>



            <div class="row mt-5 mb-5">
                <div class="col-12 mt-5">
                    <table class="table table-bordered">
                        <thead class="main-bill-thead">
                            <tr >
                                <th scope="col">اجمالي المبلغ</th>
                                <th scope="col"></th>
                                <th scope="col"></th>
                                <th scope="col" class="text-end">Total Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?php echo e($data->total_amount); ?> SAR</td>
                                <td>الإجمالي ( غير شامل ضريبة القيمة المضافة)</td>
                                <td class="text-end">Total (Excluding VAT)</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo e($data->discount); ?> SAR</td>
                                <td>مجموع الخصومات</td>
                                <td class="text-end">Discounts</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo e($data->total_amount -  $data->discount); ?> SAR</td>
                                <td>
                                    الإجمالي الخاضع للضريبة(غير شاملة <br>
                                    ضريبة القيمة المضافة)
                                </td>
                                <td class="text-end">Total Taxable Amount (Excluding VAT) </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo e($data->tax); ?> SAR</td>
                                <td>مجموع ضريبة القيمة المضافة</td>
                                <td class="text-end">Total VAT</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td><?php echo e($data->overall); ?> SAR</td>
                                <td>إجمالي المبلغ المستحق</td>
                                <td class="text-end">Total Amount Due</td>
                                <td></td>
                            </tr>

                        </tbody>
                    </table>
                </div>
            </div>



        </div>
    </div>
</body>

</html><?php /**PATH /home/happytimes/smartcashier.mo3dy.com/resources/views/bill/bill3.blade.php ENDPATH**/ ?>