@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Reset Password') }}</div>

                <div class="card-body">
                    <form method="POST" action="{{ route('password.update') }}">
                        @csrf

                        <input type="hidden" name="token" value="{{ $token }}">

                        <div class="form-group row">
                            <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('E-Mail Address') }}</label>

                            <div class="col-md-6">
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('Password') }}</label>

                            <div class="col-md-6">
                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('Confirm Password') }}</label>

                            <div class="col-md-6">
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Reset Password') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>استعادة كلمة المرور</title>
    <!-- font google  -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;700;900&display=swap"
        rel="stylesheet">
    <!-- main css -->
    <link rel="stylesheet" href="../../assets/css/style.css">
    <!-- change password css  -->
    <link rel="stylesheet" href="../../assets/css/sign&Login/forget-pass.css">
</head>

<body dir="rtl">
    <main>
        <div class="container">
            <div class="title">
                <h1>انشاء كلمة المرور جديدة</h1>
                <h4>قم بكتابة كلمة المرور قوية ليصعب تخمينها من المخترقين وتأكد من الاحتفاظ بها تجنبا لفقدها</h4>
            </div>

            <form method="POST" action="{{ route('password.update') }}">
                        @csrf

                        <input type="hidden" name="token" value="{{ $token }}">

                        <div class="parent-password">
                    <label for="password-new">البريد الالكتروني</label>
                    <div class="password-group">
                        <input type="password" name="email" id="password-new" class="password-input" />
                        <span class="icon" style="top: 15px;">
                            <img src="../../assets/img/icon/visibility.png" alt="visibility-icon">

                        </span>
                        
                        @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                    </div>
                </div>

                <div class="parent-password">
                    <label for="password-new">كلمة المرور</label>
                    <div class="password-group">
                        <input type="password" name="password" id="password-new" class="password-input" />
                        <span class="icon" style="top: 15px;">
                            <img src="../../assets/img/icon/visibility.png" alt="visibility-icon">

                        </span>
                        
                        @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                    </div>
                </div>
                <div class="parent-password">
                    <label for="password-new-done">تأكيد كلمة المرور </label>
                    <div class="password-group">
                        <input type="password" id="password-new-done"  name="password_confirmation" class="password-input" />
                        <span class="icon" style="top: 15px;">
                            <img src="../../assets/img/icon/visibility.png" alt="visibility-icon">

                        </span>
                    </div>
                </div>
                <div class="submit-container">
                    <div class="submit">
                        <button type="submit">تأكيد</button>
                    </div>
                </div>
            </form>
            <div class="footer-title">
                <h5>منصه مصممة طبق لمواصفات وشروط هيئة الزكاة والضريبة للمملكة العربية السعودية</h5>
            </div>
        </div>
    </main>
</body>

</html>