function inserted(el, binding, vnode) {
  const {
    self = false
  } = binding.modifiers || {};
  const value = binding.value;
  const options = typeof value === 'object' && value.options || {
    passive: true
  };
  const handler = typeof value === 'function' || 'handleEvent' in value ? value : value.handler;
  const target = self ? el : binding.arg ? document.querySelector(binding.arg) : window;
  if (!target) return;
  target.addEventListener('scroll', handler, options);
  el._onScroll = Object(el._onScroll);
  el._onScroll[vnode.context._uid] = {
    handler,
    options,
    // Don't reference self
    target: self ? undefined : target
  };
}

function unbind(el, binding, vnode) {
  var _el$_onScroll;

  if (!((_el$_onScroll = el._onScroll) != null && _el$_onScroll[vnode.context._uid])) return;
  const {
    handler,
    options,
    target = el
  } = el._onScroll[vnode.context._uid];
  target.removeEventListener('scroll', handler, options);
  delete el._onScroll[vnode.context._uid];
}

export const Scroll = {
  inserted,
  unbind
};
export default Scroll;
//# sourceMappingURL=index.js.map