"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Intersect = void 0;

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function inserted(el, binding, vnode) {
  if (typeof window === 'undefined' || !('IntersectionObserver' in window)) return;
  var modifiers = binding.modifiers || {};
  var value = binding.value;

  var _ref = _typeof(value) === 'object' ? value : {
    handler: value,
    options: {}
  },
      handler = _ref.handler,
      options = _ref.options;

  var observer = new IntersectionObserver(function () {
    var _el$_observe;

    var entries = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var observer = arguments.length > 1 ? arguments[1] : undefined;

    var _observe = (_el$_observe = el._observe) == null ? void 0 : _el$_observe[vnode.context._uid];

    if (!_observe) return; // Just in case, should never fire

    var isIntersecting = entries.some(function (entry) {
      return entry.isIntersecting;
    }); // If is not quiet or has already been
    // initted, invoke the user callback

    if (handler && (!modifiers.quiet || _observe.init) && (!modifiers.once || isIntersecting || _observe.init)) {
      handler(entries, observer, isIntersecting);
    }

    if (isIntersecting && modifiers.once) unbind(el, binding, vnode);else _observe.init = true;
  }, options);
  el._observe = Object(el._observe);
  el._observe[vnode.context._uid] = {
    init: false,
    observer: observer
  };
  observer.observe(el);
}

function unbind(el, binding, vnode) {
  var _el$_observe2;

  var observe = (_el$_observe2 = el._observe) == null ? void 0 : _el$_observe2[vnode.context._uid];
  if (!observe) return;
  observe.observer.unobserve(el);
  delete el._observe[vnode.context._uid];
}

var Intersect = {
  inserted: inserted,
  unbind: unbind
};
exports.Intersect = Intersect;
var _default = Intersect;
exports.default = _default;
//# sourceMappingURL=index.js.map