"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../../../src/components/VProgressCircular/VProgressCircular.sass");

var _intersect = _interopRequireDefault(require("../../directives/intersect"));

var _colorable = _interopRequireDefault(require("../../mixins/colorable"));

var _helpers = require("../../util/helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Styles
// Directives
// Mixins
// Utils

/* @vue/component */
var _default = _colorable.default.extend({
  name: 'v-progress-circular',
  directives: {
    intersect: _intersect.default
  },
  props: {
    button: Boolean,
    indeterminate: Boolean,
    rotate: {
      type: [Number, String],
      default: 0
    },
    size: {
      type: [Number, String],
      default: 32
    },
    width: {
      type: [Number, String],
      default: 4
    },
    value: {
      type: [Number, String],
      default: 0
    }
  },
  data: function data() {
    return {
      radius: 20,
      isVisible: true
    };
  },
  computed: {
    calculatedSize: function calculatedSize() {
      return Number(this.size) + (this.button ? 8 : 0);
    },
    circumference: function circumference() {
      return 2 * Math.PI * this.radius;
    },
    classes: function classes() {
      return {
        'v-progress-circular--visible': this.isVisible,
        'v-progress-circular--indeterminate': this.indeterminate,
        'v-progress-circular--button': this.button
      };
    },
    normalizedValue: function normalizedValue() {
      if (this.value < 0) {
        return 0;
      }

      if (this.value > 100) {
        return 100;
      }

      return parseFloat(this.value);
    },
    strokeDashArray: function strokeDashArray() {
      return Math.round(this.circumference * 1000) / 1000;
    },
    strokeDashOffset: function strokeDashOffset() {
      return (100 - this.normalizedValue) / 100 * this.circumference + 'px';
    },
    strokeWidth: function strokeWidth() {
      return Number(this.width) / +this.size * this.viewBoxSize * 2;
    },
    styles: function styles() {
      return {
        height: (0, _helpers.convertToUnit)(this.calculatedSize),
        width: (0, _helpers.convertToUnit)(this.calculatedSize)
      };
    },
    svgStyles: function svgStyles() {
      return {
        transform: "rotate(".concat(Number(this.rotate), "deg)")
      };
    },
    viewBoxSize: function viewBoxSize() {
      return this.radius / (1 - Number(this.width) / +this.size);
    }
  },
  methods: {
    genCircle: function genCircle(name, offset) {
      return this.$createElement('circle', {
        class: "v-progress-circular__".concat(name),
        attrs: {
          fill: 'transparent',
          cx: 2 * this.viewBoxSize,
          cy: 2 * this.viewBoxSize,
          r: this.radius,
          'stroke-width': this.strokeWidth,
          'stroke-dasharray': this.strokeDashArray,
          'stroke-dashoffset': offset
        }
      });
    },
    genSvg: function genSvg() {
      var children = [this.indeterminate || this.genCircle('underlay', 0), this.genCircle('overlay', this.strokeDashOffset)];
      return this.$createElement('svg', {
        style: this.svgStyles,
        attrs: {
          xmlns: 'http://www.w3.org/2000/svg',
          viewBox: "".concat(this.viewBoxSize, " ").concat(this.viewBoxSize, " ").concat(2 * this.viewBoxSize, " ").concat(2 * this.viewBoxSize)
        }
      }, children);
    },
    genInfo: function genInfo() {
      return this.$createElement('div', {
        staticClass: 'v-progress-circular__info'
      }, this.$slots.default);
    },
    onObserve: function onObserve(entries, observer, isIntersecting) {
      this.isVisible = isIntersecting;
    }
  },
  render: function render(h) {
    return h('div', this.setTextColor(this.color, {
      staticClass: 'v-progress-circular',
      attrs: {
        role: 'progressbar',
        'aria-valuemin': 0,
        'aria-valuemax': 100,
        'aria-valuenow': this.indeterminate ? undefined : this.normalizedValue
      },
      class: this.classes,
      directives: [{
        name: 'intersect',
        value: this.onObserve
      }],
      style: this.styles,
      on: this.$listeners
    }), [this.genSvg(), this.genInfo()]);
  }
});

exports.default = _default;
//# sourceMappingURL=VProgressCircular.js.map