/*
 * Copyright 2009 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import IllegalArgumentException from './IllegalArgumentException';
/*namespace com.google.zxing {*/
/**
 * Simply encapsulates a width and height.
 */
var Dimension = /** @class */ (function () {
    function Dimension(width /*int*/, height /*int*/) {
        this.width = width;
        this.height = height;
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
    }
    Dimension.prototype.getWidth = function () {
        return this.width;
    };
    Dimension.prototype.getHeight = function () {
        return this.height;
    };
    /*@Override*/
    Dimension.prototype.equals = function (other) {
        if (other instanceof Dimension) {
            var d = other;
            return this.width === d.width && this.height === d.height;
        }
        return false;
    };
    /*@Override*/
    Dimension.prototype.hashCode = function () {
        return this.width * 32713 + this.height;
    };
    /*@Override*/
    Dimension.prototype.toString = function () {
        return this.width + 'x' + this.height;
    };
    return Dimension;
}());
export default Dimension;
//# sourceMappingURL=Dimension.js.map