# object.omit [![NPM version](https://img.shields.io/npm/v/object.omit.svg?style=flat)](https://www.npmjs.com/package/object.omit) [![NPM monthly downloads](https://img.shields.io/npm/dm/object.omit.svg?style=flat)](https://npmjs.org/package/object.omit) [![NPM total downloads](https://img.shields.io/npm/dt/object.omit.svg?style=flat)](https://npmjs.org/package/object.omit) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/object.omit.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/object.omit)

> Return a copy of an object excluding the given key, or array of keys. Also accepts an optional filter function as the last argument.

Follow this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), for updates on this project and others.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save object.omit
```

## Usage

```js
var omit = require('object.omit');
```

Pass a string `key` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, 'a')
//=> { b: 'b', c: 'c' }
```

Pass an array of `keys` to omit:

```js
omit({a: 'a', b: 'b', c: 'c'}, ['a', 'c'])
//=> { b: 'b' }
```

Returns the object if no keys are passed:

```js
omit({a: 'a', b: 'b', c: 'c'})
//=> {a: 'a', b: 'b', c: 'c'}
```

Returns an empty object if no value is passed.

```js
omit()
//=> {}
```

### Filter function

An optional filter function may be passed as the last argument, with or without keys passed on the arguments:

**filter on keys**

```js
var res = omit({a: 'a', b: 'b', c: 'c'}, function (val, key) {
  return key === 'a';
});
//=> {a: 'a'}
```

**filter on values**

```js
var fn = function() {};
var obj = {a: 'a', b: 'b', c: fn};

var res = omit(obj, ['a'], function (val, key) {
  return typeof val !== 'function';
});
//=> {b: 'b'}
```

## About

### Related projects

You might also be interested in these projects:

* [object.defaults](https://www.npmjs.com/package/object.defaults): Like `extend` but only copies missing properties/values to the target object. | [homepage](https://github.com/jonschlinkert/object.defaults "Like `extend` but only copies missing properties/values to the target object.")
* [object.filter](https://www.npmjs.com/package/object.filter): Create a new object filtered to have only properties for which the callback returns true. | [homepage](https://github.com/jonschlinkert/object.filter "Create a new object filtered to have only properties for which the callback returns true.")
* [object.pick](https://www.npmjs.com/package/object.pick): Returns a filtered copy of an object with only the specified keys, similar to `_.pick… [more](https://github.com/jonschlinkert/object.pick) | [homepage](https://github.com/jonschlinkert/object.pick "Returns a filtered copy of an object with only the specified keys, similar to`_.pick` from lodash / underscore.")
* [object.pluck](https://www.npmjs.com/package/object.pluck): Like pluck from underscore / lo-dash, but returns an object composed of specified properties, with… [more](https://github.com/jonschlinkert/object.pluck) | [homepage](https://github.com/jonschlinkert/object.pluck "Like pluck from underscore / lo-dash, but returns an object composed of specified properties, with values unmodified from those of the original object.")
* [object.reduce](https://www.npmjs.com/package/object.reduce): Reduces an object to a value that is the accumulated result of running each property… [more](https://github.com/jonschlinkert/object.reduce) | [homepage](https://github.com/jonschlinkert/object.reduce "Reduces an object to a value that is the accumulated result of running each property in the object through a callback.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 21 | [jonschlinkert](https://github.com/jonschlinkert) |
| 1 | [bfred-it](https://github.com/bfred-it) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on September 03, 2017._