<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class showprice extends Model
{
   protected $fillable = [
'orderpackage_id',
    'price',
   'discount',
    'tax',
'total_amount',
'customer_id',
'per_discount',
'code',
'fq',
'branch_id',
'overall',
'created_at'
   ];

   protected $with = [
       'product','payment','customer'
   ];

   
   public function showprice(){
    return $this->belongsto(customer::class,'customer_id');
}

   public function product(){
       return $this->belongstomany(product::class,'showprice_product')->withPivot('showprice_id','product_id','quantity');
   }

   public function payment(){
       return $this->HasMany(payment::class,'showprice_id');
   }


   public function branch(){
    return $this->belongsto(branch::class,'branch_id');
}

   public function customer(){
    return $this->belongsto(customer::class,'customer_id');
}
  
}
