<?php

namespace App\Http\Controllers;
use Validator;
use Illuminate\Http\Request;
use App\supplierorder;
use DB;
use App\Exceptions\CustomException;
class supplierorderController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function supplierordercreate(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
   
        ){
return view('supplierorder.create');

        }
    }



    public function supplierorderindex(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  

        
        ){
            return view('supplierorder.index');


        }
    }


    public function insert(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')


        ){
            $this->validate($request,[
                'code'=>['string','required','max:255'],
                'supplier_id'=>['required','numeric'],
              'fq'=>['string'],
            ]);

            try{
 
                DB::transaction(function () use ($request) {

            if($request->isedit == true){

 $supplierorder =      auth()->user()->orderpackage->supplierorder()->where('id',$request->s_id)->first();

 $supplierorder->update([
    'code'=>$request->code,
    'supplier_id'=>$request->supplier_id,
'fq'=>$request->fq,
'orderpackage_id'=>auth()->user()->orderpackage->id,
]);


            }
     else{


 $supplierorder   =    supplierorder::create([
            'code'=>$request->code,
            'supplier_id'=>$request->supplier_id,
     'fq'=>$request->fq,
     'orderpackage_id'=>auth()->user()->orderpackage->id,
        ]);

    
    }
$supplierorder->product()->detach();

$rules = [
    "quantity"  => "required|numeric",
   'id'=> 'required','numeric','exists:products,id',

   
];
        $product = json_decode($request->product, true);
        foreach($product as $v){
      
            $array = [
                "quantity"  => $v['pivot']['quantity'] ?? null ,
               'id'=> $v['id'] ?? null,
       
               
            ];
              $validator = Validator::make(
          $array,$rules
          
            );
          if ($validator->passes() ) {

            $supplierorder->product()->attach($v['id'], [
               
                'quantity' => $v['pivot']['quantity'],
            ]);
        }else{
     
            $errors  = $validator->errors()->toArray();
            $data = json_encode($errors);
          
                    throw new CustomException ($data);
    
        }

    }
 
    });
 


}
catch (Exception $e) {
    return $e;
}


    }
    }


    public function supplierorderjson(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){

return response()->json(['data'=>auth()->user()->orderpackage->supplierorder()->orderBy('created_at', 'DESC')->with('supplier')->paginate(10)]);

        }
    }


     
    public function delete($ids){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
      
        
        ){
          auth()->user()->orderpackage->supplierorder()->whereIn('id',explode(",",$ids))->delete();
        }
      }



      public function getselectsupplierorder(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $supplierorder = auth()->user()->orderpackage
        ->supplierorder()->where('code', 'LIKE', '%' . $request->code . '%')->get()->take(5);
        return response()->json(['data'=>$supplierorder]);
        }
       }


       public function supplierorderselectright($id){
        if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){
       
            $data =      auth()->user()->orderpackage->supplierorder()->where('code',$id)->with(['product','supplier'])->first();
           
            return response()->json(['data'=>$data]);
       
       }
       
 
       
       }
       public function supplierorderselectright_edit($id){
        if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){
       
            $data =      auth()->user()->orderpackage->supplierorder()->where('id',$id)->with(['product','supplier'])->first();
       
            return view('supplierorder.create')->with(['editdata'=>$data]);
       
       }
    }

      public function updatesupplierorder(request $request,supplierorder $supplierorder ){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
      
        
        ){
  $supplierorder->update([
    
    'supplier_id'=>$request->supplier_id,

]);
              
              return response()->json('done',200);
        }
    }


                  // Supplier order Print   -Index-

    public function sp_print($id){
        if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){

             


            $data =auth()->user()->orderpackage->supplierorder()->where('code',$id)->with(['product','Supplier'])->get()[0];
         

            return view('print.supplierrequest')->with(['data'=>$data]);
       
         
}


         





    }
    public function supplierorder_count(){

        

        if(auth()->user()->orderpackage  && auth()->user()->orderpackage->date >= date('Y-m-d')){

         
    
          return response()->json(['data'=>count(auth()->user()->orderpackage->supplierorder()->get())]);
    
    
    
    
        
      }
    }
    

}
