<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Redirect;

use DB;

use Illuminate\Http\Request;
use App\showprice;
use App\payment;
use App\offerpaid;
use Validator;
use App\paymentoffer;
use App\entry_manual;
use App\entry_manual_account;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\product;
class salesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function createoffer(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','add_عرض الأسعار')->count() > 0
        
      
        
        ){
        return view('sales.offer');
        }
    }

    public function offertable(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','read_عرض الأسعار')->count() > 0
        
      
        
        ){
        return view('sales.offertable');
        }
    }


    public function insertoffer(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','add_عرض الأسعار')->count() > 0
        
      
        
        ){


            $this->validate($request,[
                'discount'=>['required','numeric'],
                'tax'=>['required','numeric'],
            'total_amount'=>['required','numeric'],
            'branch_id'=>['required','numeric'],
            'overall'=>['required','numeric'],
            'customer_id'=>['required','numeric'],
            
            
            'discount_per'=>['numeric'],
            
            'discount'=>['numeric'],
            ]);
            

     
    
        try{
    


            DB::transaction(function () use ($request) {
    
                if($request->isedit == true){

                    $sho = auth()->user()->orderpackage->showprice()->where('id',$request->show_id)->with(['product','payment'])->first();
              
                    $sho->update([
            'customer_id'=>$request->customer_id,
           
            'fq'=>$request->fq,
              'price'=>$request->price,
             'discount'=>$request->discount,
             'customer_id'=>$request->customer_id,
              'tax'=>$request->tax,
              'branch_id'=>$request->branch_id,
              'orderpackage_id'=>auth()->user()->orderpackage->id,
          'total_amount'=>$request->total_amount,
          'per_discount'=>$request->per_discount,
          'overall'=>$request->overall,
        ]);
            

        $sho->product()->detach();
        
                }  


               
                if($request->isedit == false){
                    $offerpaidcode = auth()->user()->orderpackage->showprice()->count() +1;
      $sho = showprice::create([
      'customer_id'=>$request->customer_id,
      'code'=>$offerpaidcode,
      'fq'=>$request->fq,
        'price'=>$request->price,
       'discount'=>$request->discount,
       'customer_id'=>$request->customer_id,
        'tax'=>$request->tax,
        'branch_id'=>$request->branch_id,
        'orderpackage_id'=>auth()->user()->orderpackage->id,
    'total_amount'=>$request->total_amount,
    'per_discount'=>$request->per_discount,
    'overall'=>$request->overall,

      ])  ;

                }


      $payments = json_decode($request->payment, true);

      $product = json_decode($request->product, true);
$a = [];
    

    if($request->isedit == true){

        if(!empty($sho->payment)){
            foreach($sho->payment as $payment){
                $payment->delete();

            }
        }

    }
    if(!empty($payments)){
foreach($payments as $p){
    
     
        $a[] = [
            'showprice_id'=>$sho->id,
            'percentage'=>$p['percentage'],
         'name'=>$p['name'],
        'note'=>$p['note']?? null,
        
        'amount'=>$p['amount'],
        
        ];
    }
    


    payment::insert($a);

}

foreach($product as $v){
    $rules = [
          
       
        "quantity"  => "required|numeric",
    
       
       'id'=> "required|numeric",
       
    ];
    
    $validator = Validator::make($v, $rules);
   
 if($request->isedit == false){
    $sho->product()->attach($v['id'], [
       
        'quantity' => $v['quantity'],
    ]);
 }else{
    $sho->product()->attach($v['id'], [
       
        'quantity' => $v['quantity'],
    ]);
 }
  

}
   

    return view('sales.offertable');



    



            });
        }
        catch (Exception $e) {
            return $e;
        }
        }
    }

    public function insertofferpaid(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','add_الفواتير')->count() > 0
        
        ){
        $this->validate($request,[

   'discount'=>['required','numeric'],
    'tax'=>['required','numeric'],
    'overall'=>['required','numeric'],
'total_amount'=>['required','numeric'],
'branch_id'=>['required','numeric'],

'customer_id'=>['required','numeric'],


'discount_per'=>['numeric'],

'discount'=>['numeric'],


        ]);
        try{
    
            DB::transaction(function () use ($request) {
    
    
        $offerpaidcode = auth()->user()->orderpackage->offerpaid()->count() +1;
      $sho = offerpaid::create([
      'customer_id'=>$request->customer_id,
      'code_offer'=>$request->code_offer,
      'fq'=>$request->fq,
   'code'=>$offerpaidcode,

   'date'=> \Carbon\Carbon::today()->format('m/d/Y'),
       'discount'=>$request->discount,
       'taxnum'=>$request->taxnum,
        'tax'=>$request->tax,
        'date_of_supply'=>$request->date_of_supply,
        'discount_per'=>$request->discount_per,
        'branch_id'=>$request->branch_id,
        'orderpackage_id'=>auth()->user()->orderpackage->id,
    'total_amount'=>$request->total_amount,
    'overall'=>$request->overall,
'showprice_id'=>$request->showprice_id,
      ])  ;


      $code = auth()->user()->orderpackage->entry_manual->count() + 1;
        $entry_manual = entry_manual::create([
      'orderpackage_id'=>auth()->user()->orderpackage->id,
     'date'=>\Carbon\Carbon::now()->format('Y-m-d'),
           'creditor_id'=>$d ?? null, 
            'value'=>$sho->overall,
        'dis'=>'فاتورة بيع '.''.$offerpaidcode,
        'line'=>1,
'type'=>10,
      'code'=>$code,
      'hide'=>1
        ]);


        $da =  auth()->user()->orderpackage->accountbank()->where('code',1)->with(['subaccount1'=>
        function($d){
            $d->where('code',11)->with(['sub_account3'=> function($r) {
         return   
        
         $r->where('code',1103);
           }]);
        }]);
        $da = $da->first();
        $d = $da['subaccount1'][0]['sub_account3'][0]['id'];
    
 
    $e =  entry_manual_account::create([
        
        'debtor_sub_account4_id'=>null,
        'debtor_account3_id'=>$d,
     'entry_manual_id'=>$entry_manual->id,
     'value'=>$sho->overall,
     'date'=>$entry_manual->date,
    
    ]);
    $e->sub_account3()->increment('initial_balance',$sho->overall);
    $e->sub_account3->subaccount1()->increment('initial_balance',$sho->overall);
    $e->sub_account3->subaccount1->accountbank->increment('initial_balance',$sho->overall);

      


      $payment = json_decode($request->payment, true);

      $product = json_decode($request->product, true);
$a = [];
if(!empty($payment)){
    foreach($payment as $p){
        $rules = [
        
            "percentage"  => "required|numeric",
            'name'=> "required|string|max:255",
           'note'=> "string|max:255",
           'amount'=> "required|numeric",
           
        ];
    
       

if($p){
    $a[] = [
            
        'offerpaid_id'=>$sho->id,
        'percentage'=>$p['percentage'],
     'name'=>$p['name'],
    'note'=>$p['note'] ?? null ,
    
    'amount'=>$p['amount'],
    
    ];
}

      
        
    }

    paymentoffer::insert($a);

}
   
foreach($product as $v){

    $sho->product()->attach($v['id'], [
        'quantity' => $v['pivot']['quantity'],
    ]);




    
    if($v['inventory'] == 1){

 
      
          $total = $v['buy_price'] * $v['pivot']['quantity'] ?? 0;

      $da =  auth()->user()->orderpackage->accountbank()->where('code',1)->with(['subaccount1'=>
            function($d){
                $d->where('code',11)->with(['sub_account3'=> function($r) {
             return   
       
             $r->where('code',1106);
               }]);
            }]);
            $da = $da->first();
            $d = $da['subaccount1'][0]['sub_account3'][0]['id'];
       
          
      $e =  entry_manual_account::create([

         'creditor_sub_account3_id'=>$d,
      'entry_manual_id'=>$entry_manual->id,
      'value'=>$total,
      'date'=>$entry_manual->date,
      ]);



      if($e->creditor_sub_account3()->count() >0){
        $e->creditor_sub_account3()->increment('initial_balance',$e->value);
        $e->creditor_sub_account3->subaccount1()->increment('initial_balance',$e->value);
$e->creditor_sub_account3->subaccount1->accountbank()->increment('initial_balance',$e->value);
        }


    }


}



foreach($product as $v){


    $total = $v['selling'] * $v['pivot']['quantity'] ?? 0;

    if($sho->tax > 0){
      $da =  auth()->user()->orderpackage->accountbank()->where('code',2)->with(['subaccount1'=>
    function($d){
        $d->where('code',21)->with(['sub_account3'=> function($r) {
     return   
    
     $r->where('code',2105);
       }]);
    }]);
    $da = $da->first();
    $d = $da['subaccount1'][0]['sub_account3'][0]['id'];
   
    $tax =  auth()->user()->orderpackage->branch->where('id',$request->branch_id)->first();

      $e =  entry_manual_account::create([
        'debtor_account3_id'=>null,
         'debtor_sub_account4_id'=>null,
         'creditor_sub_account3_id'=>$d,
      'entry_manual_id'=>$entry_manual->id,
      'value'=>  $v['pivot']['quantity'] * $v['selling']  *  $tax->tax  / 100
      
     
      ,
      'date'=>$entry_manual->date,
      ]);
    


      if($e->creditor_sub_account3()->count() >0){
        $e->creditor_sub_account3()->increment('initial_balance',$e->value);
        $e->creditor_sub_account3->subaccount1()->increment('initial_balance',$e->value);
$e->creditor_sub_account3->subaccount1->accountbank()->increment('initial_balance',$e->value);
        }


    }




  
}




    foreach($product as $v){

     
    
            $total = $v['selling'] * $v['pivot']['quantity'] ?? 0;
            $e =  entry_manual_account::create([
              'creditor_sub_account4_id'=>$v['selling_account4_id'],
              'creditor_sub_account3_id'=>$v['selling_account3_id'],
         
            'entry_manual_id'=>$entry_manual->id,
            'value'=>$total,
            'date'=>$entry_manual->date,
            ]);
      
            if($e->creditor_sub_account3()->count() >0){
            $e->creditor_sub_account3()->increment('initial_balance',$total);
            $e->creditor_sub_account3->subaccount1()->increment('initial_balance',$total);
$e->creditor_sub_account3->subaccount1->accountbank()->increment('initial_balance',$total);
            }
if($e->creditor_sub_account4()->count() >0){
    $e->creditor_sub_account4()->increment('initial_balance',$total);
    $e->creditor_sub_account4->sub_account3()->decrement('initial_balance',$total);
    $e->creditor_sub_account4->sub_account3->subaccount1()->decrement('initial_balance',$total);
    $e->creditor_sub_account4->sub_account3->subaccount1->accountbank->decrement('initial_balance',$total);
        
}

        
    }



    foreach($product as $v){

     
    if($v['inventory'] == 1){
        $e =  entry_manual_account::create([
            'debtor_sub_account4_id'=>$v['p_account4_id'],
            'debtor_account3_id'=>$v['p_account3_id'],
         'entry_manual_id'=>$entry_manual->id,
         'value'=>$v['buy_price'] * $v['pivot']['quantity'] ?? 0,
         'date'=>$entry_manual->date,
         ]);
    

if($e->sub_account4()->count() > 0){
  $e->sub_account4()->increment('initial_balance',$total);
  
    $e->sub_account4->sub_account3()->increment('initial_balance',$total);
    $e->sub_account4->sub_account3->subaccount1()->increment('initial_balance',$total);
    $e->sub_account4->sub_account3->subaccount1->accountbank->increment('initial_balance',$total);
}

if($e->sub_account3()->count() > 0){
  $e->sub_account3()->increment('initial_balance',$total);
       
  $e->sub_account3->subaccount1()->increment('initial_balance',$total);
  $e->sub_account3->subaccount1->accountbank->increment('initial_balance',$total);
}


    }
    
  

    
}

    


});

}
catch (Exception $e) {
    return $e;
}

        }


 
    }


    public function getselectproduct(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->product()->where('id', 'LIKE', '%' . $request->code . '%')->get()->take(3);
        return response()->json(['data'=>$product]);
        }
       }

       public function getselectproductpurchase(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->product()->where('id', 'LIKE', '%' . $request->code . '%')->where('buy_price','>',0)->get()->take(3);
        return response()->json(['data'=>$product]);
        }
       }


       public function getselectproductbarcodepurchase(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->product()->where('barcode', 'LIKE', '%' . $request->barcode . '%')->where('type',1)->where('buy_price','>',0)->where('buy_price','>',0)->first();
        return response()->json(['data'=>$product]);
        }
       }

       public function getselectproductnamepurchase(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->product()->where('name', 'LIKE', '%' . $request->name . '%')->where('type',1)->where('buy_price','>',0)->get()->take(3);
        return response()->json(['data'=>$product]);
        }
       }


       public function getselectproductbarcode(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->product()->where('barcode', 'LIKE', '%' . $request->barcode . '%')->first();
        return response()->json(['data'=>$product]);
        }
       }

       
       public function getselectproductname(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->product()->where('name', 'LIKE', '%' . $request->name . '%')->get()->take(3);
        return response()->json(['data'=>$product]);
        }
       }

       public function getselectcustomer(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage->customer()
        ->where('customer_name', 'LIKE', '%' . $request->name . '%')
        
        ->orwhere('comp', 'LIKE', '%' . $request->name . '%')->where('package_id',auth()->user()->orderpackage->id)
        ->get()->take(5);

  
       
        
        return response()->json(['data'=>$product]);
        }
       }

       public function getselectpriceshow(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->showprice()->where('code', 'LIKE', '%' . $request->code. '%')
        ->with('customer')->get()->take(5);
        return response()->json(['data'=>$product]);
        }
       }
       public function getselectpriceshow_edit($id){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $offer = auth()->user()->orderpackage
        ->showprice()->where('id', 'LIKE', '%' . $id. '%')
        ->with(['customer','branch'])->first();
        if($offer == null ){  
        return view('sales.offertable');
        }   
            
        return view('sales.offer')->with(['editdata' => $offer ]);
        }
       }


       public function getofferpaid(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
           return view('sales.offerpaid');
        }
       }


       public function bill1($id){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','read_الفواتير')->count() > 0
        
      
        
        ){
           if(auth()->user()->orderpackage->offerpaid()->where('id',$id)->first()){

$data = auth()->user()->orderpackage->offerpaid()->with(['customer',

'product','paymentoffer','branch','showprice'

])->where('id',$id)->first();

$slug = [
    'name'=>$data->branch->name ?? null,
    'tax_number'=>$data->branch->tax_number  ?? null,
    'date'=>$data->created_at->format('d/m/Y') ?? null,
'tax'=>$data->tax  ?? null,
'total_amount'=>$data->overall ?? null,



];

$arrData = json_encode($slug, JSON_UNESCAPED_UNICODE);

$q =  QrCode::size(190)->encoding('UTF-8')
->backgroundColor(255, 255, 204)

->generate($arrData);


return view('bill.bill1')->with(['data'=>$data,'slug'=>$q]);
           }
        }
           
       }

       public function bill2($id){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','read_الفواتير')->count() > 0
        
      
        
        ){
        if(auth()->user()->orderpackage->offerpaid()->where('id',$id)->first()){

$data = auth()->user()->orderpackage->offerpaid()->with('showprice')->where('id',$id)->first();


return view('bill.bill2')->with('data',$data);
        }
    }

    }

    public function offerpaidpage(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','read_عرض الأسعار')->count() > 0
        
      
        
        ){
            return view('sales.offerpaidtable');

        }
    }

    public function offerpaidjson(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){

            $data = auth()->user()->orderpackage->offerpaid()->orderBy('created_at', 'DESC')->with('customer')->paginate(10);

            return response()->json(['data'=>$data]);


        }
    }

    public function getpricejson(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->showprice()->orderBy('created_at', 'DESC')->with('customer')->paginate(10);
        return response()->json(['data'=>$product]);
        }
       }

       public function deleteoffer($ids){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
          auth()->user()->orderpackage->showprice()->whereIn('id',explode(",",$ids))->delete();
        }
      }
}

