<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\product;
class productController extends Controller
{
  public function __construct()
  {
      $this->middleware('auth');
  }

  public function edit($product){
     
    if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')   
    
    && 
    auth()->user()->role->permession->where('name','add_أصناف المنتجات')->count() > 0
    
    ){

      $product = auth()->user()->orderpackage->product()->with(['category','unit','suppiler','inventoryz' ,

      'selling_account3','selling_account4',

      'p_account3','p_account4',
      ])->where('id',$product)->first();
     

      
          return view('product.edit')->with(['data'=>$product]);   
        }
      
    }

    public function product(){
     
  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')   
  
  && 
  auth()->user()->role->permession->where('name','add_أصناف المنتجات')->count() > 0
  
  ){
   
        return view('product.product');   
      }
    }

public function addproduct(request $request){
  
  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')   
  
  && 
  auth()->user()->role->permession->where('name','add_أصناف المنتجات')->count() > 0
  
  ){
   
 $this->validate($request,[
  
  'type'=>['required','numeric','digits_between:1,2'],
    'name'=>['required','string','max:255'],

   'group'=>['required','numeric'],
  'measuring'=>['required','numeric'],
    'barcode'=>['string','max:255'],
    
 'selling'=>['required','numeric'],
'inventory'=>['required','numeric','digits_between:1,2'],


])   ;



if($request->type  == 1){
  $this->validate($request,[
   'buy_price'=>['required','numeric'],
  ])   ;
}

if($request->selling_account3_id == null && $request->selling_account4_id == null ){
  $this->validate($request,[
  
    'selling_account4_id'=>['required','numeric'],
    'selling_account3_id'=>['required','numeric'],
  ])   ;
  
}

if($request->p_account3_id == null && $request->p_account4_id == null && $request->type == 1){
  $this->validate($request,[
  
    'p_account4_id'=>['required','numeric'],
    'p_account3_id'=>['required','numeric'],
  ])   ;
  
}




 if($request->inventory == 1){
  $this->validate($request,[
  'loaction_inventory'=>['required','numeric','max:255'],
  'quantity'=>['required','string','max:255'],
     'min_quantity'=>['required','string','max:255'],
     'inventory'=>['required','numeric'],
  'place'=>['required','string','max:255'],
    'auto_order'=>['required','numeric','digits_between:1,2'],
  ]);
 }

 if($request->img){
  $image_tmp = $request->img;
      // Upload Images after Resize
      $extension = $image_tmp->getClientOriginalExtension();
      $fileName = rand(111,99999).'.'.$extension;
      $image_tmp->move('uploads/product', $fileName);

}else{
  $fileName = null;
}

 $product =  product::create([
      
  'type'=>$request->type,
  'name'=>$request->name,
'orderpackage_id'=>auth()->user()->orderpackage->id,
 'group'=>$request->group,
'measuring'=>$request->measuring,
  'barcode'=>$request->barcode,
 'dis'=>$request->dis,
'code'=>$request->code,
'place'=>$request->place,
 'buy_price'=>$request->buy_price,
'selling'=>$request->selling,
'img'=>$fileName,
'inventory'=>$request->inventory,
'loaction_inventory'=>$request->loaction_inventory,
'quantity'=>$request->quantity,
  'min_quantity'=>$request->min_quantity,
'supplier_name'=>$request->supplier_name,
 'supplier_tax_number'=>$request->supplier_tax_number,
 'selling_account3_id'=>$request->selling_account3_id,
 'selling_account4_id'=>$request->selling_account4_id,
 'p_account3_id'=>$request->p_account3_id,
 'p_account4_id'=>$request->p_account4_id,
'supplier_email'=>$request->supplier_email,
'supplier_id'=>$request->supplier_id,
 'auto_order'=>$request->auto_order,
]);

$product->inventorym()->attach($request->loaction_inventory,[
  'quantity'=>$request->quantity,
]);

return response()->json('done',200);



  }
}


public function updateproduct(request $request,$product){
  
  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')   
  
  && 
  auth()->user()->role->permession->where('name','add_أصناف المنتجات')->count() > 0
  
  ){
   
$pro = auth()->user()->orderpackage->product()->where('id',$product)->first();

$this->validate($request,[
  
  'type'=>['required','numeric','digits_between:1,2'],
    'name'=>['required','string','max:255'],

   'group'=>['required','numeric'],
  'measuring'=>['required','numeric'],
    'barcode'=>['string','max:255'],
    
 'selling'=>['required','numeric'],
'inventory'=>['required','numeric','digits_between:1,2'],


])   ;


 if($request->inventory == 1){
  $this->validate($request,[
  'loaction_inventory'=>['required','numeric','max:255'],
  'quantity'=>['required','string','max:255'],
     'min_quantity'=>['required','string','max:255'],
     'inventory'=>['required','numeric'],
  'place'=>['required','string','max:255'],
    'auto_order'=>['required','numeric','digits_between:1,2'],
  ]);
 }

 
if($request->type  == 1){
  $this->validate($request,[
   'buy_price'=>['required','numeric'],
  ])   ;
}

if($request->selling_account3_id == null && $request->selling_account4_id == null ){
  $this->validate($request,[
  
    'selling_account4_id'=>['required','numeric'],
    'selling_account3_id'=>['required','numeric'],
  ])   ;
  
}

if($request->p_account3_id == null && $request->p_account4_id == null && $request->type == 1){
  $this->validate($request,[
  
    'p_account4_id'=>['required','numeric'],
    'p_account3_id'=>['required','numeric'],
  ])   ;
  
}


 if($request->img){
  $image_tmp = $request->img;
      // Upload Images after Resize
      $extension = $image_tmp->getClientOriginalExtension();
      $fileName = rand(111,99999).'.'.$extension;
      $image_tmp->move('uploads/product', $fileName);

}else{
  $fileName = null;
}

 $pro->update([
      
  'type'=>$request->type,
  'name'=>$request->name,

 'group'=>$request->group,
'measuring'=>$request->measuring,
  'barcode'=>$request->barcode,
 'dis'=>$request->dis,

'code'=>$request->code,
'place'=>$request->place,
 'buy_price'=>$request->buy_price,
'selling'=>$request->selling,
'inventory'=>$request->inventory,
'loaction_inventory'=>$request->loaction_inventory,
'quantity'=>$request->quantity,
  'min_quantity'=>$request->min_quantity,
'supplier_name'=>$request->supplier_name,
 'supplier_tax_number'=>$request->supplier_tax_number,
 'selling_account3_id'=>$request->selling_account3_id,
 'selling_account4_id'=>$request->selling_account4_id,
 'p_account3_id'=>$request->p_account3_id,
 'p_account4_id'=>$request->p_account4_id,
'supplier_email'=>$request->supplier_email,
'supplier_id'=>$request->supplier_id,
 'auto_order'=>$request->auto_order,
]);
if($fileName){
  $pro->update([
    'img'=>$fileName,
    ]);
}


$pro->inventorym()->sync($request->loaction_inventory,[
  'quantity'=>$request->quantity  ?? 0,
]);
return response()->json('done',200);
  }
}


public function editproduct(request $request,product $product){
  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')

  && 
  auth()->user()->role->permession->where('name','add_أصناف المنتجات')->count() > 0

  ){
 $this->validate($request,[
  
  'type'=>['required','numeric','digits_between:1,2'],
    'name'=>['required','string','max:255'],

   'group'=>['required','string','max:255'],

    'barcode'=>['required','string','max:255'],
 
 ])   ;



      
$product->type = $request->type;
$product->name =$request->name;

$product->group=$request->group;

$product->barcode=$request->barcode;
$product->selling = $request->selling;
$product->buy_price = $request->buy_price;

$product->save();

return response()->json('done',200);
  }
}


public function producttable(){
  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
  && 
  auth()->user()->role->permession->where('name','read_المنتجات')->count() > 0
  
  
  
  ){
return view('product.table');
  }
}

public function productjson(){
  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
$pr = auth()->user()->orderpackage->product()->with(['category','unit'])->orderBy('created_at', 'DESC')->paginate(10);
return response()->json(['data'=>$pr]);

  }
}

public function productselect(){
  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
$pr = auth()->user()->orderpackage->product()->orderBy('created_at', 'DESC')->get()->chunk(10);
return response()->json(['data'=>$pr]);

  }
}


public function delete($ids){

  if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
  && 
  auth()->user()->role->permession->where('name','delete_أصناف المنتجات')->count() > 0
  

  
  
  ){
    $product  = product::whereIn('id',explode(",",$ids))->get();
    foreach($product as $pro){
      if(!empty($pro->inventorym())){
        $pro->inventorym()->detach();
        $pro->offerpaid()->detach();
        $pro->purchase_order()->detach();
$pro->showprice()->detach();
$pro->pricing_supplier()->detach();
$pro->supplierorder()->detach();
$pro->supplierorder()->detach();
      }
  
    }
   

 $product  =  product::whereIn('id',explode(",",$ids))->delete();
  }
}

}
