<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\inventory;

class inventoryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function edit(inventory $inventory){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','add_المواقع')->count() > 0
        
      
        
        ){
        return view('inventory.edit')->with('data',$inventory);
        }
    }

    public function create(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','add_المواقع')->count() > 0
        
      
        
        ){
        return view('inventory.create');
        }
    }

    public function home(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','read_المواقع')->count() > 0
        
      
        
        ){

        return view('inventory.home');
        }
    }


    public function inventoryhomedata(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $inventory = auth()->user()->orderpackage->inventory()->paginate(10);
        return response()->json(['data'=>$inventory]);
        }
    }

    public function inventoryselectbox(){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $inventory = auth()->user()->orderpackage->inventory()->get()->chunk(10);
        return response()->json(['data'=>$inventory]);
        }
    }


    public function update(request $request,inventory $inventory){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','add_المواقع')->count() > 0
        
      
        
        ){

$this->validate($request,[

    "name"    => "required|max:255",
 
    'neigh' => "required|max:255",

    'city'=> "required|max:255",
    
      'street'=> "required|max:255",
   
    'storage'=> "required|max:255",

]);



    $inventory->update([
'name'=>$request->name,
'neigh'=>$request->neigh,
'city'=>$request->city,
'street'=>$request->street,
'storage'=>$request->storage,

    ]);

    



return redirect()->route('inventoryhome');
        }
    }

    public function inventoryinserter(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','add_المواقع')->count() > 0
        
      
        
        ){

$this->validate($request,[

    "name"    => "required|max:255",
    "name.*"  => "required|string|max:255",
    'neigh' => "required|max:255",
    'neigh.*'  => "required|string|max:255",
    'city'=> "required|max:255",
    'city.*'=> "required|string|max:255",
      'street'=> "required|max:255",
      'street.*'=> "required|string|max:255",
    'storage'=> "required|max:255",
    'storage.*'=> "required|string|max:255",
]);

$c = 0;
foreach($request->name as $n){

    $inventory = inventory::create([
'name'=>$n,
'neigh'=>$request->neigh[$c],
'city'=>$request->city[$c],
'street'=>$request->street[$c],
'storage'=>$request->storage[$c],
'orderpackage_id'=>auth()->user()->orderpackage->id,
    ]);

    ++$c;

}

return redirect()->route('inventoryhome');
        }
    }

    public function delete(inventory $inventory ){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')
  
        && 
        auth()->user()->role->permession->where('name','delete_المواقع')->count() > 0
        
      
        
        ){
$inventory->delete();

        }
    }

    public function getselectinventory(request $request){
        if(auth()->user()->orderpackage && auth()->user()->orderpackage->date >= date('Y-m-d')){
        $product = auth()->user()->orderpackage
        ->inventory()->orderBy('created_at', 'DESC')->where('name', 'LIKE', '%' . $request->name . '%')->get()->take(5);
        return response()->json(['data'=>$product]);
        }
       }
}

